/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.eks.tpcds;

import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.process.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class CleanUpMergeTables$ {
    public static CleanUpMergeTables$ MODULE$;

    static {
        new CleanUpMergeTables$();
    }

    public void main(String[] args) {
        Try try_;
        Predef$.MODULE$.println((Object)"Starting CleanUpMergeTables");
        Predef$.MODULE$.require(args.length >= 3, (Function0 & Serializable & scala.Serializable)() -> "Usage: CleanUpMergeTables <parquetDir> <icebergDir> <database> [onlyWarn]");
        String parquetSourceDirectory = args[0];
        String icebergWarehouseDirectory = args[1];
        String hive_database = args[2];
        boolean onlyWarn = ((Option)Predef$.MODULE$.wrapRefArray((Object[])args).lift().apply((Object)BoxesRunTime.boxToInteger((int)3))).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CleanUpMergeTables$.$anonfun$main$2(x$1)));
        SparkSession spark = SparkSession$.MODULE$.builder().appName(new StringBuilder(32).append("TPCDS Clean up merge tables for ").append(hive_database).toString()).enableHiveSupport().getOrCreate();
        if (onlyWarn) {
            Predef$.MODULE$.println((Object)"Only WARN");
            LogManager.getLogger((String)"org").setLevel(Level.WARN);
        }
        if ((try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            spark.sql(new StringBuilder(32).append("DROP DATABASE IF EXISTS ").append(hive_database).append(" CASCADE").toString());
            MODULE$.deleteS3Directory(parquetSourceDirectory);
            MODULE$.deleteS3Directory(icebergWarehouseDirectory);
        })) instanceof Success) {
            Predef$.MODULE$.println((Object)new StringBuilder(24).append("Successfully cleaned up ").append(hive_database).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("Failed to clean up ").append(hive_database).append(": ").append(e.getMessage()).toString());
            e.printStackTrace();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
        spark.stop();
    }

    private void deleteS3Directory(String path) {
        String normalizedPath = path.endsWith("/") ? path : new StringBuilder(1).append(path).append("/").toString();
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Deleting S3 directory: ").append(normalizedPath).toString());
        String output = package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aws", "s3", "rm", normalizedPath, "--recursive"}))).$bang$bang();
        Predef$.MODULE$.println((Object)output);
    }

    public static final /* synthetic */ boolean $anonfun$main$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    private CleanUpMergeTables$() {
        MODULE$ = this;
    }
}

