/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.sql.perf.mllib.classification;

import com.databricks.spark.sql.perf.MLMetric;
import com.databricks.spark.sql.perf.mllib.BenchmarkAlgorithm;
import com.databricks.spark.sql.perf.mllib.MLBenchContext;
import com.databricks.spark.sql.perf.mllib.OptionImplicits$;
import com.databricks.spark.sql.perf.mllib.ScoringWithEvaluator;
import com.databricks.spark.sql.perf.mllib.TestFromTraining;
import com.databricks.spark.sql.perf.mllib.TrainingSetFromTransformer;
import com.databricks.spark.sql.perf.mllib.data.DataGenerator$;
import java.io.Serializable;
import java.util.Random;
import org.apache.spark.ml.ModelBuilderSSP$;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.classification.LinearSVC;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.java8.JFunction0;

public final class LinearSVC$
implements BenchmarkAlgorithm,
TestFromTraining,
TrainingSetFromTransformer,
ScoringWithEvaluator {
    public static LinearSVC$ MODULE$;

    static {
        new LinearSVC$();
    }

    @Override
    public final MLMetric score(MLBenchContext ctx, Dataset<Row> testSet, Transformer model) {
        return ScoringWithEvaluator.score$(this, ctx, testSet, model);
    }

    @Override
    public final Dataset<Row> trainingDataSet(MLBenchContext ctx) {
        return TrainingSetFromTransformer.trainingDataSet$(this, ctx);
    }

    @Override
    public final Dataset<Row> testDataSet(MLBenchContext ctx) {
        return TestFromTraining.testDataSet$(this, ctx);
    }

    @Override
    public String name() {
        return BenchmarkAlgorithm.name$(this);
    }

    @Override
    public Map<String, Function0<?>> testAdditionalMethods(MLBenchContext ctx, Transformer transformer) {
        return BenchmarkAlgorithm.testAdditionalMethods$(this, ctx, transformer);
    }

    @Override
    public Dataset<Row> initialData(MLBenchContext ctx) {
        return DataGenerator$.MODULE$.generateContinuousFeatures(ctx.sqlContext(), OptionImplicits$.MODULE$.oL2L(ctx.params().numExamples()), ctx.seed(), OptionImplicits$.MODULE$.oI2I(ctx.params().numPartitions()), OptionImplicits$.MODULE$.oI2I(ctx.params().numFeatures()));
    }

    @Override
    public Transformer trueModel(MLBenchContext ctx) {
        Random rng = ctx.newGenerator();
        Vector coefficients = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(OptionImplicits$.MODULE$.oI2I(ctx.params().numFeatures()), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> (double)2 * rng.nextDouble() - 1.0, ClassTag$.MODULE$.Double()));
        double intercept = 0.01 * ((double)2 * rng.nextDouble() - 1.0);
        return ModelBuilderSSP$.MODULE$.newLinearSVCModel(coefficients, intercept);
    }

    @Override
    public PipelineStage getPipelineStage(MLBenchContext ctx) {
        return new LinearSVC().setTol(OptionImplicits$.MODULE$.oD2D(ctx.params().tol())).setMaxIter(OptionImplicits$.MODULE$.oI2I(ctx.params().maxIter())).setRegParam(OptionImplicits$.MODULE$.oD2D(ctx.params().regParam()));
    }

    @Override
    public Evaluator evaluator(MLBenchContext ctx) {
        return new MulticlassClassificationEvaluator();
    }

    private LinearSVC$() {
        MODULE$ = this;
        BenchmarkAlgorithm.$init$(this);
        TestFromTraining.$init$(this);
        TrainingSetFromTransformer.$init$(this);
        ScoringWithEvaluator.$init$(this);
    }
}

