/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.sql.perf.mllib.data;

import com.databricks.spark.sql.perf.mllib.data.DataGenerator$;
import com.databricks.spark.sql.perf.mllib.data.DocGenerator;
import com.databricks.spark.sql.perf.mllib.data.DocGenerator$;
import com.databricks.spark.sql.perf.mllib.data.FeaturesGenerator;
import com.databricks.spark.sql.perf.mllib.data.GaussianMixtureDataGenerator;
import com.databricks.spark.sql.perf.mllib.data.ItemSetGenerator;
import com.databricks.spark.sql.perf.mllib.data.RandStringGenerator;
import com.databricks.spark.sql.perf.mllib.data.RatingGenerator;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.random.RandomRDDs$;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple1;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class DataGenerator$ {
    public static DataGenerator$ MODULE$;

    static {
        new DataGenerator$();
    }

    public Dataset<Row> generateContinuousFeatures(SQLContext sql, long numExamples, long seed, int numPartitions, int numFeatures) {
        int[] featureArity = (int[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
        RDD rdd = RandomRDDs$.MODULE$.randomRDD(sql.sparkContext(), (RandomDataGenerator)new FeaturesGenerator(featureArity), numExamples, numPartitions, seed, ClassTag$.MODULE$.apply(Vector.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$1() {
            }
        }
        return sql.createDataFrame(rdd.map((Function1 & Serializable & scala.Serializable)_1 -> new Tuple1(_1), ClassTag$.MODULE$.apply(Tuple1.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$1())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features"}));
    }

    public Dataset<Row> generateMixedFeatures(SQLContext sql, long numExamples, long seed, int numPartitions, int[] featureArity) {
        RDD rdd = RandomRDDs$.MODULE$.randomRDD(sql.sparkContext(), (RandomDataGenerator)new FeaturesGenerator(featureArity), numExamples, numPartitions, seed, ClassTag$.MODULE$.apply(Vector.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$2() {
            }
        }
        return sql.createDataFrame(rdd.map((Function1 & Serializable & scala.Serializable)_1 -> new Tuple1(_1), ClassTag$.MODULE$.apply(Tuple1.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$2())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features"}));
    }

    public Dataset<Row> generateGaussianMixtureData(SQLContext sql, int numCenters, long numExamples, long seed, int numPartitions, int numFeatures) {
        RDD rdd = RandomRDDs$.MODULE$.randomRDD(sql.sparkContext(), (RandomDataGenerator)new GaussianMixtureDataGenerator(numCenters, numFeatures, seed), numExamples, numPartitions, seed, ClassTag$.MODULE$.apply(Vector.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$3() {
            }
        }
        return sql.createDataFrame(rdd.map((Function1 & Serializable & scala.Serializable)_1 -> new Tuple1(_1), ClassTag$.MODULE$.apply(Tuple1.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$3())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features"}));
    }

    public Tuple2<Dataset<Row>, Dataset<Row>> generateRatings(SQLContext sql, int numUsers, int numProducts, long numExamples, long numTestExamples, boolean implicitPrefs, int numPartitions, long seed) {
        SparkContext sc = sql.sparkContext();
        RDD train = RandomRDDs$.MODULE$.randomRDD(sc, (RandomDataGenerator)new RatingGenerator(numUsers, numProducts, implicitPrefs), numExamples, numPartitions, seed, ClassTag$.MODULE$.apply(ALS.Rating.class)).cache();
        RDD test = RandomRDDs$.MODULE$.randomRDD(sc, (RandomDataGenerator)new RatingGenerator(numUsers, numProducts, implicitPrefs), numTestExamples, numPartitions, seed + 24L, ClassTag$.MODULE$.apply(ALS.Rating.class));
        PairRDDFunctions commons = new PairRDDFunctions(train.keyBy((Function1 & Serializable & scala.Serializable)rating -> new Tuple2.mcII.sp(rating.user$mcI$sp(), rating.item$mcI$sp())).cache(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(ALS.Rating.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        RDD exact = commons.join(test.keyBy((Function1 & Serializable & scala.Serializable)rating -> new Tuple2.mcII.sp(rating.user$mcI$sp(), rating.item$mcI$sp())));
        RDD trainPruned = commons.subtractByKey(exact, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x$1 -> (ALS.Rating)x$1._2(), ClassTag$.MODULE$.apply(ALS.Rating.class)).cache();
        RDD trainUsers = trainPruned.keyBy((Function1 & Serializable & scala.Serializable)rating -> BoxesRunTime.boxToInteger((int)rating.user$mcI$sp()));
        PairRDDFunctions testUsers = new PairRDDFunctions(test.keyBy((Function1 & Serializable & scala.Serializable)rating -> BoxesRunTime.boxToInteger((int)rating.user$mcI$sp())), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ALS.Rating.class), (Ordering)Ordering.Int$.MODULE$);
        RDD testWithAdditionalUsers = testUsers.subtractByKey(trainUsers, ClassTag$.MODULE$.apply(ALS.Rating.class));
        RDD userPrunedTestProds = testUsers.subtractByKey(testWithAdditionalUsers, ClassTag$.MODULE$.apply(ALS.Rating.class)).map((Function1 & Serializable & scala.Serializable)x$2 -> (ALS.Rating)x$2._2(), ClassTag$.MODULE$.apply(ALS.Rating.class)).keyBy((Function1 & Serializable & scala.Serializable)rating -> BoxesRunTime.boxToInteger((int)rating.item$mcI$sp()));
        RDD trainProds = trainPruned.keyBy((Function1 & Serializable & scala.Serializable)rating -> BoxesRunTime.boxToInteger((int)rating.item$mcI$sp()));
        RDD testWithAdditionalProds = new PairRDDFunctions(userPrunedTestProds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ALS.Rating.class), (Ordering)Ordering.Int$.MODULE$).subtractByKey(trainProds, ClassTag$.MODULE$.apply(ALS.Rating.class));
        RDD finalTest = new PairRDDFunctions(userPrunedTestProds, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ALS.Rating.class), (Ordering)Ordering.Int$.MODULE$).subtractByKey(testWithAdditionalProds, ClassTag$.MODULE$.apply(ALS.Rating.class)).map((Function1 & Serializable & scala.Serializable)x$3 -> (ALS.Rating)x$3._2(), ClassTag$.MODULE$.apply(ALS.Rating.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml.recommendation")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.ml.recommendation.ALS")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.recommendation.ALS.Rating"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$4() {
            }
        }
        public final class Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml.recommendation")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.ml.recommendation.ALS")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.recommendation.ALS.Rating"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator2$1() {
            }
        }
        return new Tuple2((Object)sql.createDataFrame(trainPruned, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$4())), (Object)sql.createDataFrame(finalTest, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator2$1())));
    }

    public Dataset<Row> generateRandString(SQLContext sql, long numExamples, long seed, int numPartitions, int distinctCount, String dataColName) {
        RDD rdd = RandomRDDs$.MODULE$.randomRDD(sql.sparkContext(), (RandomDataGenerator)new RandStringGenerator(distinctCount), numExamples, numPartitions, seed, ClassTag$.MODULE$.apply(String.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$5
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$5() {
            }
        }
        return sql.createDataFrame(rdd.map((Function1 & Serializable & scala.Serializable)_1 -> new Tuple1(_1), ClassTag$.MODULE$.apply(Tuple1.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$5())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{dataColName}));
    }

    public Dataset<Row> generateDoc(SQLContext sql, long numExamples, long seed, int numPartitions, int vocabSize, int avgDocLength, String dataColName) {
        RDD rdd = RandomRDDs$.MODULE$.randomRDD(sql.sparkContext(), (RandomDataGenerator)new DocGenerator(vocabSize, avgDocLength, DocGenerator$.MODULE$.$lessinit$greater$default$3()), numExamples, numPartitions, seed, ClassTag$.MODULE$.apply(String.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$6
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$6() {
            }
        }
        return sql.createDataFrame(rdd.map((Function1 & Serializable & scala.Serializable)_1 -> new Tuple1(_1), ClassTag$.MODULE$.apply(Tuple1.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$6())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{dataColName}));
    }

    public Dataset<Row> generateItemSet(SQLContext sql, long numExamples, long seed, int numPartitions, int numItems, int avgItemSetSize) {
        RDD rdd = RandomRDDs$.MODULE$.randomRDD(sql.sparkContext(), (RandomDataGenerator)new ItemSetGenerator(numItems, avgItemSetSize), numExamples, numPartitions, seed, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$7
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$7() {
            }
        }
        return sql.createDataFrame(rdd.map((Function1 & Serializable & scala.Serializable)_1 -> new Tuple1(_1), ClassTag$.MODULE$.apply(Tuple1.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_databricks_spark_sql_perf_mllib_data_DataGenerator$$typecreator1$7())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"items"}));
    }

    private DataGenerator$() {
        MODULE$ = this;
    }
}

