/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml;

import org.apache.spark.ml.TreeBuilder$;
import org.apache.spark.ml.classification.ClassificationModelBuilder$;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.LinearSVCModel;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.NaiveBayesModel;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.tree.Node;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxedUnit;

public final class ModelBuilderSSP$ {
    public static ModelBuilderSSP$ MODULE$;

    static {
        new ModelBuilderSSP$();
    }

    public LogisticRegressionModel newLogisticRegressionModel(Vector coefficients, double intercept) {
        return new LogisticRegressionModel("lr", coefficients, intercept).setThreshold(0.5);
    }

    public LinearRegressionModel newLinearRegressionModel(Vector coefficients, double intercept) {
        LinearRegressionModel model = new LinearRegressionModel("linr", coefficients, intercept);
        Object object = model.hasParam("loss") ? model.set(model.getParam("loss"), (Object)"squaredError") : BoxedUnit.UNIT;
        return model;
    }

    public GeneralizedLinearRegressionModel newGLR(Vector coefficients, double intercept) {
        return new GeneralizedLinearRegressionModel("glr-uid", coefficients, intercept);
    }

    public DecisionTreeClassificationModel newDecisionTreeClassificationModel(int depth, int numClasses, int[] featureArity, long seed) {
        Predef$.MODULE$.require(numClasses >= 2, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(72).append("DecisionTreeClassificationModel requires numClasses >= 2,").append(" but was given ").append(numClasses).toString());
        Node rootNode = TreeBuilder$.MODULE$.randomBalancedDecisionTree(depth, numClasses, featureArity, seed);
        return new DecisionTreeClassificationModel(rootNode, featureArity.length, numClasses);
    }

    public DecisionTreeRegressionModel newDecisionTreeRegressionModel(int depth, int[] featureArity, long seed) {
        Node rootNode = TreeBuilder$.MODULE$.randomBalancedDecisionTree(depth, 0, featureArity, seed);
        return new DecisionTreeRegressionModel(rootNode, featureArity.length);
    }

    public NaiveBayesModel newNaiveBayesModel(Vector pi, Matrix theta) {
        NaiveBayesModel model = new NaiveBayesModel("naivebayes-uid", pi, theta, null);
        return (NaiveBayesModel)model.set(model.modelType(), (Object)"multinomial");
    }

    public LinearSVCModel newLinearSVCModel(Vector coefficients, double intercept) {
        return ClassificationModelBuilder$.MODULE$.newLinearSVCModel(coefficients, intercept);
    }

    private ModelBuilderSSP$() {
        MODULE$ = this;
    }
}

