/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml;

import java.io.Serializable;
import org.apache.spark.ml.TreeBuilder;
import org.apache.spark.ml.tree.CategoricalSplit;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class TreeBuilder$ {
    public static TreeBuilder$ MODULE$;

    static {
        new TreeBuilder$();
    }

    public Node randomBalancedDecisionTree(int depth, int labelType, int[] featureArity, long seed) {
        boolean isRegression;
        Predef$.MODULE$.require(depth >= 0, (Function0 & Serializable & scala.Serializable)() -> "randomBalancedDecisionTree given depth < 0.");
        int numFeatures = featureArity.length;
        Predef$.MODULE$.require(depth <= numFeatures, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("randomBalancedDecisionTree requires depth <= featureArity.size,").append(" but depth = ").append(depth).append(" and featureArity.size = ").append(numFeatures).toString());
        boolean bl = isRegression = labelType == 0;
        if (!isRegression) {
            Predef$.MODULE$.require(labelType >= 2, (Function0 & Serializable & scala.Serializable)() -> "labelType must be >= 2 for classification. 0 indicates regression.");
        }
        Random rng = new Random();
        rng.setSeed(seed);
        Object labelGenerator = isRegression ? new TreeBuilder.RealLabelPairGenerator() : new TreeBuilder.ClassLabelPairGenerator(labelType);
        labelGenerator.setSeed(rng.nextLong());
        ImpurityCalculator impurityCalculator = isRegression ? ImpurityCalculator$.MODULE$.getCalculator("variance", (double[])Array$.MODULE$.fill(3, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double()), 0L) : ImpurityCalculator$.MODULE$.getCalculator("gini", (double[])Array$.MODULE$.fill(labelType, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double()), 0L);
        return this.randomBalancedDecisionTreeHelper(depth, featureArity, impurityCalculator, (RandomDataGenerator<Tuple2<Object, Object>>)labelGenerator, (Set<Object>)Predef$.MODULE$.Set().empty(), rng);
    }

    private Node randomBalancedDecisionTreeHelper(int subtreeDepth, int[] featureArity, ImpurityCalculator impurityCalculator, RandomDataGenerator<Tuple2<Object, Object>> labelGenerator, Set<Object> usedFeatures, Random rng) {
        Node node;
        Node rightChild;
        ContinuousSplit split;
        block10: {
            Tuple2 tuple2;
            block9: {
                Tuple2 tuple22;
                ContinuousSplit continuousSplit;
                if (subtreeDepth == 0) {
                    return new LeafNode(0.0, 0.0, impurityCalculator);
                }
                int numFeatures = featureArity.length;
                Predef$.MODULE$.assert(usedFeatures.size() < numFeatures, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("randomBalancedDecisionTreeSplitNode ran out of ").append("features for splits.").toString());
                int feature = rng.nextInt(numFeatures);
                while (usedFeatures.contains((Object)BoxesRunTime.boxToInteger((int)feature))) {
                    feature = rng.nextInt(numFeatures);
                }
                if (featureArity[feature] == 0) {
                    continuousSplit = new ContinuousSplit(feature, rng.nextDouble());
                } else {
                    int nCatsSplit = rng.nextInt(featureArity[feature] - 1) + 1;
                    double[] splitCategories = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])rng.shuffle((TraversableOnce)package$.MODULE$.Range().apply(0, featureArity[feature]).toList(), List$.MODULE$.canBuildFrom()).toArray(ClassTag$.MODULE$.Int()))).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$1 -> x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).take(nCatsSplit);
                    continuousSplit = split = new CategoricalSplit(feature, splitCategories, featureArity[feature]);
                }
                if (subtreeDepth == 1) {
                    Tuple2 predictions = (Tuple2)labelGenerator.nextValue();
                    LeafNode leftChild = new LeafNode(predictions._1$mcD$sp(), 0.0, impurityCalculator);
                    LeafNode rightChild2 = new LeafNode(predictions._2$mcD$sp(), 0.0, impurityCalculator);
                    tuple22 = new Tuple2((Object)leftChild, (Object)rightChild2);
                } else {
                    Node leftChild = this.randomBalancedDecisionTreeHelper(subtreeDepth - 1, featureArity, impurityCalculator, labelGenerator, (Set<Object>)((Set)usedFeatures.$plus((Object)BoxesRunTime.boxToInteger((int)feature))), rng);
                    Node rightChild3 = this.randomBalancedDecisionTreeHelper(subtreeDepth - 1, featureArity, impurityCalculator, labelGenerator, (Set<Object>)((Set)usedFeatures.$plus((Object)BoxesRunTime.boxToInteger((int)feature))), rng);
                    tuple22 = tuple2 = new Tuple2((Object)leftChild, (Object)rightChild3);
                }
                if (tuple2 == null) break block9;
                Node leftChild = (Node)tuple2._1();
                rightChild = (Node)tuple2._2();
                if (leftChild == null) break block9;
                node = leftChild;
                if (rightChild != null) break block10;
            }
            throw new MatchError((Object)tuple2);
        }
        Node node2 = rightChild;
        Tuple2 tuple2 = new Tuple2((Object)node, (Object)node2);
        Tuple2 tuple23 = tuple2;
        Node leftChild = (Node)tuple23._1();
        Node rightChild4 = (Node)tuple23._2();
        return new InternalNode(0.0, 0.0, 0.0, leftChild, rightChild4, (Split)split, impurityCalculator);
    }

    private TreeBuilder$() {
        MODULE$ = this;
    }
}

